<?php

function get_sandbox_controller_info($argv) {
	if(count($argv) < 1) {
		exit(1);
	}

	if(($dtas_cfg = new SimpleXMLElement(file_get_contents($argv[0]))) == FALSE) {
		exit(1);
	}

	// Try connecting database	
	$dbHost = $dtas_cfg->db->host;
	$dbUser = $dtas_cfg->db->username;
	$dbPassword =  $dtas_cfg->db->password;
	$heartbeatInterval = (int)$dtas_cfg->sc_heart_beat->interval;

	if(($dbConn = pg_connect("host=$dbHost dbname=dtasdb port=5432 user=$dbUser password=$dbPassword")) == FALSE) {
		exit(1);
	}

	if(($resource = pg_query_params($dbConn, 'SELECT ip, sc_id, sb_num, hb_time FROM tb_sc_info WHERE sc_id <> 0', array())) == FALSE) {
		pg_close($dbConn);
		exit(1);
	}

	if(($arrResult = pg_fetch_all($resource)) == FALSE) {
		pg_close($dbConn);
		exit(1);
	}

	foreach($arrResult as $sc) {
		$tNow = new DateTime("now", new DateTimeZone("UTC"));// Note: Currently the store procedure fn_RegisterSandboxController uses system time zone (Asia/Taipei) 
		//$tLastHb = new DateTime($sc["hb_time"], new DateTimeZone("Asia/Taipei"));
		$tLastHb = new DateTime($sc["hb_time"], new DateTimeZone("UTC"));

		$tDiff = abs($tNow->getTimeStamp() - $tLastHb->getTimeStamp());
		if($tDiff > 2*$heartbeatInterval) {
			printf("Sandbox Controller [%s] : Off Line\n", $sc["ip"]);
			continue;
		}
		else {
			printf("Sandbox Controller [%s]\n", $sc["ip"]);
		}
		if(($resourceSbInfo = pg_query_params($dbConn, 'SELECT sb_ip, status FROM tb_sb_status WHERE sc_id = $1 ORDER BY status DESC', array($sc["sc_id"]))) == FALSE) {
			break;
		}

		if(($arrSbResult = pg_fetch_all($resourceSbInfo)) == FALSE) {
			break;
		}

		printf("\tSandbox List:\n");

		foreach($arrSbResult as $sb) {
			printf("\t\t %s : %s\n", $sb["sb_ip"], $sb["status"] == "1" ? "Available" : "Not Available");
		}

		pg_free_result($resourceSbInfo);
	}

	pg_free_result($resource);
	pg_close($dbConn);
}

